#region Includes
using GroundhogLearning.GameKit.Utils;
using UnityEngine;
using UnityEngine.Events;
#endregion

namespace GroundhogLearning.GameKit
{
    [AddComponentMenu(EditorMenuConfig.CATEGORY_TIME + "Stopwatch")]
    public class Stopwatch : MonoBehaviour
    {
        #region Variables

        [Header("Configuration")]

        [SerializeField, Tooltip("If true, the stopwatch starts automatically when the scene starts.")]
        private bool _autoStart;

        [Header("Events")]

        [SerializeField, Tooltip("Invoked with the raw time value (in seconds) whenever the time updates.")]
        private UnityEvent<float> OnTimeValueChanged;

        [SerializeField, Tooltip("Invoked with the formatted time value (MM:SS) whenever the time updates.")]
        private UnityEvent<string> OnFormattedTimeValueChanged;

        private bool _isRunning;
        private float _time;

        #endregion

        private void Start()
        {
            _isRunning = _autoStart;
        }
        private void Update()
        {
            if (!_isRunning) return;

            _time += Time.deltaTime;

            OnTimeValueChanged?.Invoke(_time);
            OnFormattedTimeValueChanged?.Invoke(FormatTime(_time));
        }

        public void StartStopwatch()
        {
            _isRunning = true;
        }
        public void StopStopwatch()
        {
            _isRunning = false;
        }
        public void ResetStopwatch()
        {
            _time = 0f;
        }

        private static string FormatTime(float time)
        {
            var minutes = Mathf.FloorToInt(time / 60f);
            var seconds = Mathf.FloorToInt(time % 60f);
            return $"{minutes:00}:{seconds:00}";
        }
    }
}